duplicates drop station_id, force
sort station_id

*Assign each station to a grid cell
gen grid_size_lat = 2.5
gen count = -90 + (grid_size_lat / 2)
gen latgrid = .
forvalues latcoords = -90(2.5)90 {
    replace latgrid = count if (lat > `latcoords' | lat == `latcoords') & lat < (`latcoords' + grid_size_lat)
    replace count = count + grid_size_lat
}

gen grid_size_lon = 3.5
replace count = -180 + (grid_size_lon / 2)
gen longrid = .
forvalues loncoords = -180(3.5)180 {
    replace longrid = count if (lon > `loncoords' | lon == `loncoords') & lon < (`loncoords' + grid_size_lon)
    replace count = count + grid_size_lon
}

*Remove grid cell assignments if the global variable $grid is set to false
replace latgrid = 0 if "$grid" == "false"
replace longrid = 0 if "$grid" == "false"

*Create a unique gridbox identifier
gen latseperator = " lat "
gen lonseperator = " lon"
egen gridbox = concat(latgrid latseperator longrid lonseperator)
drop latseperator lonseperator

*Create a grid weight based on latitude (formula courtesy of RomanM)
gen grid_weight = sin((latgrid+grid_size_lat/2)*_pi/180) - sin((latgrid-grid_size_lat/2)*_pi/180) 

sort station_id
